####################
# ## PARAMETERS ## #
####################

config = {
  # paths for connecting to cloud storage
  "vm_path": 'ebm-life-cycle/',
  "gs_path": 'gen-tfrc-europewest4',
  "exp_name": 'celeb_a_longrun_test',
  "exp_dir": 'tfrc_out/fid',

  # device type ('tpu' or 'gpu' or 'cpu')
  "device_type": 'tpu',
  # number of gpus if using gpu device
  #'num_gpus': 1,

  # exp params
  "exp_type": "folder",
  "num_fid_rounds": 1,
  "batch_size": 16,
  "image_dims": [64, 64, 3],
  "split": "train",
 
  # ckpt folder
  "ckpt_folder": 'gs://gen-tfrc-uscentral1/tfrc_out/celeb_a/nonconv_resnet_21-08-09-01-25-01',
  "epoch_freq": 5000,
  "min_epoch": 5000,
  "max_epoch": 145000,

  # data type and augmentation parameters
  "data_type": 'celeb_a',
 
  # ebm network
  "net_type": 'ebm_sngan',

  # prior paramters
  "prior_weights": "gs://gen-tfrc-europewest4/tfrc_out/celeb_a/nonconv_resnet_21-09-01-23-58-44/checkpoints/ebm_120000.ckpt",
  "prior_temp": 1e-4,

  # langevin sampling parameters
  "mcmc_steps": 1000000,
  "epsilon": 1e-2,
  "mcmc_init": "coop",
  #"mcmc_temp": 1e-6,
  #"tau": 1e-5,
  #"joint_temp": 1.0,
  # clipping parameters
  "clip_langevin_grad": False,
  "max_langevin_norm": 100,

  "gen_type": "gen_sngan",
  "z_sz": 128,
  "truncation": 1,
  "fixed_gen": False

}
